--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNsignParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCsignPath    = ""
  local LOCundoState   = on
  local LOCaspectRatio = 1.0
  local LOCspinStartValue
  local LOCsignsArray = #()
  local LOCiniArraysUpdateRequired = true
  local LOCresourceKitMode   = 1

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNvspSignFilter       FUNobj = (classof FUNobj.baseObject == VSP_Sign)
  fn DYNFUNvspSymbFilter       FUNobj = (classof FUNobj.baseObject == VSP_Symb)

  fn DYNFUNsignParams FUNobj =
  (
    FUNobj.baseObject.height           = FUNobj.baseObject.height
    DYNsignParams.LOCobj               = FUNobj
    DYNsignParams.SPDYNlength.value    = FUNobj.baseObject.width
    DYNsignParams.SPDYNwidth.value     = FUNobj.baseObject.height
    if classOf FUNobj.baseObject == VSP_Sign then
    (
      DYNsignParams.SPDYNheight.enabled   = true
      DYNsignParams.SPDYNdepth.enabled    = true
      DYNsignParams.SPDYNposts.enabled    = true
      DYNsignParams.SPDYNedgeOff.enabled  = true
      DYNsignParams.SPDYNheight.value     = FUNobj.baseObject.pheight
      DYNsignParams.SPDYNdepth.value      = FUNobj.baseObject.depth
      DYNsignParams.SPDYNposts.value      = FUNobj.baseObject.posts
      DYNsignParams.SPDYNedgeOff.value    = FUNobj.baseObject.edgeOff
      DYNsignParams.SPDYNedgeOff.range.y  = FUNobj.baseObject.width / 4
      DYNsignParams.PKDYNlinkSign.visible = true
      DYNsignParams.PKDYNlinkSymb.visible = false
    )
    else
    (
      DYNsignParams.SPDYNheight.enabled   = false
      DYNsignParams.SPDYNdepth.enabled    = false
      DYNsignParams.SPDYNposts.enabled    = false
      DYNsignParams.SPDYNedgeOff.enabled  = false
      DYNsignParams.PKDYNlinkSign.visible = false
      DYNsignParams.PKDYNlinkSymb.visible = true
    )

    --- Get current SignFace
    DYNsignParams.LOCsignsArray = DYNFUNgetMatChannelNames FUNobj.material false false DYNINImatIDlimit
    if DYNsignParams.LOCsignsArray.count >= 10 then (for i = 1 to 10 do deleteItem DYNsignParams.LOCsignsArray 1)
    if DYNsignParams.LOCsignsArray.count > 0 then
    (
      local LOCmatID = if (FUNobj.baseObject.type - 10) > DYNsignParams.LOCsignsArray.count then DYNsignParams.LOCsignsArray.count else (FUNobj.baseObject.type - 10)
      FUNobj.baseObject.type = LOCmatID + 10
      if DYNsignParams.LOCsignsArray.count >= (FUNobj.baseObject.type - 10) then
      (
        DYNsignParams.LBDYNobjName.text  = DYNsignParams.LOCsignsArray[FUNobj.baseObject.type - 10]
      )
      else
      (
        DYNsignParams.LBDYNobjName.text  = ""
      )

      DYNsignParams.BMDYNbitmap.bitmap = DYNFUNrenderMatMap 160 120 FUNobj.material FUNobj.baseObject.type

      --- If Sign Object INI File Definition does not exist, disable RESET and DROPDOWN list (This can occur when the wrong country kit is currently loaded)
      local LOCswitch = doesFileExist (DYNsignParams.LOCsignPath + DYNsignParams.LBDYNobjName.text + ".ini")
      DYNsignParams.BUDYNreset.enabled   = LOCswitch
    )
    else
    (
      DYNsignParams.BUDYNreset.enabled   = false
    )

    --- Create A Temporary Array Of Sign Object INI Files From Current DVSP Country Kit Folders
    local LOCsignArray = DYNFUNgetfiles DYNsignParams.LOCsignPath 1 "*.ini"
    DYNsignParams.BUDYNotherTypes.enabled = if classOf FUNobj.material == Multimaterial and LOCsignArray.count > 0 then true else false

    --- Check whether other instances exist
    DYNFUNgatherInstancesOfNode DYNsignParams FUNobj

    --- Store current aspect ratio of sign
    DYNsignParams.LOCaspectRatio = DYNsignParams.SPDYNlength.value / DYNsignParams.SPDYNwidth.value
  )


  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 21) height:193 pos:[4,7]
  bitmap BMDYNbitmap     width:(DYNiniExplorerWidth - 39) pos:[13,26] height:120
  label LBDYNobjName     width:(DYNiniExplorerWidth - 108) pos:[13,155]
  button BUDYNotherTypes width:(DYNiniExplorerWidth - 39) pos:[13,173]

  groupbox GBDYN02 width:(DYNiniExplorerWidth - 21) height:88  pos:[4,205]
  label   LBDYNlength pos:[13,224] width:(DYNiniExplorerWidth - 108)
  label   LBDYNwidth  pos:[13,245] width:(DYNiniExplorerWidth - 108)
  spinner SPDYNlength "" fieldwidth:44 range:[0.05,10000,1.0] type:#worldunits pos:[(DYNiniExplorerWidth - 96),224]
  spinner SPDYNwidth  "" fieldwidth:44 range:[0.05,10000,1.0] type:#worldunits pos:[(DYNiniExplorerWidth - 96),245]
  button  BUDYNreset  width:(DYNiniExplorerWidth - 37) pos:[13,266]
  checkbutton CBDYNlock width:16 height:18 pos:[(DYNINIexplorerWidth - 39),235] iconName:"Common/Lock" iconSize:[16,16] checked:true highlightColor:DYNINIhighlightColor

  groupbox GBDYN03 width:(DYNiniExplorerWidth - 21) height:104 pos:[4,298]
  label LBDYNheight  pos:[13,317] width:(DYNiniExplorerWidth - 108)
  label LBDYNdepth   pos:[13,338] width:(DYNiniExplorerWidth - 108)
  label LBDYNposts   pos:[13,359] width:(DYNiniExplorerWidth - 108)
  label LBDYNedgeoff pos:[13,380] width:(DYNiniExplorerWidth - 108)
  spinner SPDYNheight  "" fieldwidth:60 range:[0.1,10000,5.0] type:#worldunits pos:[(DYNiniExplorerWidth - 96),317]
  spinner SPDYNdepth   "" fieldwidth:60 range:[-10000,0,-1.0] type:#worldunits pos:[(DYNiniExplorerWidth - 96),338]
  spinner SPDYNposts   "" fieldwidth:60 range:[0,5,2]         type:#integer    pos:[(DYNiniExplorerWidth - 96),359]
  spinner SPDYNedgeoff "" fieldwidth:60 range:[0,10000.0,0.1] type:#worldunits pos:[(DYNiniExplorerWidth - 96),380]

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 21) height:72  pos:[4,407]
  checkbutton CBDYNlinked  width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor pos:[13,426]
  pickbutton PKDYNlinkSign width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor filter:DYNFUNvspSignFilter pos:[13,452]
  pickbutton PKDYNlinkSymb width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor filter:DYNFUNvspSymbFilter pos:PKDYNlinkSign.pos

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNsignParams open do
  (
    DYNsignParams.title   = DYNuiRolloutNames[19]
    GBDYN01.text          = DYNuiResourcesGroups[57]
    GBDYN02.text          = DYNuiResourcesGroups[58]
    GBDYN03.text          = DYNuiResourcesGroups[59]
    GBDYN04.text          = DYNuiResourcesGroups[1]
    LBDYNlength.text      = DYNuiResourcesLabels[29]
    LBDYNwidth.text       = DYNuiResourcesLabels[30]
    LBDYNheight.text      = DYNuiResourcesLabels[200]
    LBDYNdepth.text       = DYNuiResourcesLabels[201]
    LBDYNposts.text       = DYNuiResourcesLabels[202]
    LBDYNedgeoff.text     = DYNuiResourcesLabels[203]
    BUDYNreset.text       = DYNuiResourcesButtons[13]
    LOCsignPath           = DYNcountryPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameSigns + "\\"
    BUDYNotherTypes.text  = DYNuiResourcesButtons[57]
    PKDYNlinkSymb.text    = DYNuiResourcesButtons[24]
    PKDYNlinkSign.text    = DYNuiResourcesButtons[24]
    LOCiniArraysUpdateRequired = true
  )

  on DYNsignParams close do
  (
    LOCobj = undefined
    LOCsignsArray = #()
  )

  on BUDYNreset pressed do
  (
    local LOCsizeArray = DYNFUNobjectINIparams LBDYNobjName.text 4 LOCresourceKitMode
    SPDYNlength.value  = LOCobj.baseObject.width   = LOCsizeArray[3]
    SPDYNwidth.value   = LOCobj.baseObject.height  = LOCsizeArray[4]
    LOCaspectRatio     = SPDYNlength.value / SPDYNwidth.value
  )

  --- Length Spinner Controls
  on SPDYNlength changed arg do
  (
    LOCobj.baseObject.width = arg
    SPDYNedgeoff.range.y = arg/4
    if SPDYNedgeoff.value > (arg/4) then SPDYNedgeoff.value = (arg/4)

    if CBDYNlock.checked then
    (
      LOCobj.baseObject.height = arg / LOCaspectRatio
      SPDYNwidth.value = LOCobj.baseObject.height
    )
    else
    (
      LOCaspectRatio = SPDYNlength.value / SPDYNwidth.value
    )
  )

  --- Width Spinner Controls
  on SPDYNwidth changed arg do
  (
    LOCobj.baseObject.height = arg

    if CBDYNlock.checked then
    (
      LOCobj.baseObject.width = arg * LOCaspectRatio
      SPDYNlength.value = LOCobj.baseObject.width
      SPDYNedgeoff.range.y = LOCobj.baseObject.width/4
      if SPDYNedgeoff.value > (LOCobj.baseObject.width/4) then SPDYNedgeoff.value = (LOCobj.baseObject.width/4)
    )
    else
    (
      LOCaspectRatio = SPDYNlength.value / SPDYNwidth.value
    )
  )

  --- Height Spinner Controls
  on SPDYNheight changed arg do (with undo label:(DYNuiResourcesUndoLabels[12]) LOCundoState LOCobj.baseObject.pHeight = arg)
  on SPDYNheight buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNheight.value)
  on SPDYNheight buttonUp    do
  (
    if LOCspinStartValue != SPDYNheight.value then
    (
      with undo off LOCobj.baseObject.pHeight = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[12]) on LOCobj.baseObject.pHeight = SPDYNheight.value
    )
    LOCundoState    = on
  )

  --- Depth Spinner Controls
  on SPDYNdepth changed arg do (with undo label:(DYNuiResourcesUndoLabels[12]) LOCundoState LOCobj.baseObject.depth = arg)
  on SPDYNdepth buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNdepth.value)
  on SPDYNdepth buttonUp    do
  (
    if LOCspinStartValue != SPDYNdepth.value then
    (
      with undo off LOCobj.baseObject.depth = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[12]) on LOCobj.baseObject.depth = SPDYNdepth.value
    )
    LOCundoState    = on
  )

  --- Posts Spinner Controls
  on SPDYNposts changed arg do (with undo label:(DYNuiResourcesUndoLabels[12]) LOCundoState LOCobj.baseObject.posts = arg)
  on SPDYNposts buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNposts.value)
  on SPDYNposts buttonUp    do
  (
    if LOCspinStartValue != SPDYNposts.value then
    (
      with undo off LOCobj.baseObject.posts = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[12]) on LOCobj.baseObject.posts = SPDYNposts.value
    )
    LOCundoState    = on
  )

  --- Edge Offset Spinner Controls
  on SPDYNedgeOff changed arg do (with undo label:(DYNuiResourcesUndoLabels[12]) LOCundoState LOCobj.baseObject.edgeOff = arg)
  on SPDYNedgeOff buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNedgeOff.value)
  on SPDYNedgeOff buttonUp    do
  (
    if LOCspinStartValue != SPDYNedgeOff.value then
    (
      with undo off LOCobj.baseObject.edgeOff = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[12]) on LOCobj.baseObject.edgeOff = SPDYNedgeOff.value
    )
    LOCundoState    = on
  )

  on BUDYNotherTypes pressed do
  (
    --- Update Main Object INI File AX Internal Arrays
    if LOCiniArraysUpdateRequired then
    (
      DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
      LOCiniArraysUpdateRequired = false
    )

    --- Display Sign Selection List
    local LOCnewFile = DYNFUNdisplayListBoxWithMapPreview DYNsignParams (if classOf LOCobj.baseObject == VSP_Sign then DYNuiResourcesTitlebars[19] else DYNuiResourcesTitlebars[21]) "" 4 1 "Sign Defaults" "Style" (if classOf LOCobj.baseObject == VSP_Sign then "1" else "2")

    if LOCnewFile != "" then
    (
      if (findItem LOCsignsArray LOCnewFile) == 0 then
      (
        --- Update Current Tree Object With New Tree INI Definition
        local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 4 LOCresourceKitMode
        local LOCmatID = DYNFUNaddSignMatChannel LOCobj.material LOCsizeArray false
        LOCobj.baseObject.type = LOCmatID + 10
        SPDYNlength.value  = LOCobj.baseObject.width   = LOCsizeArray[3]
        SPDYNwidth.value   = LOCobj.baseObject.height  = LOCsizeArray[4]
        if (classof LOCobj.baseObject) == VSP_Sign then
        (
          SPDYNheight.value  = LOCobj.baseObject.pheight = LOCsizeArray[4] + LOCsizeArray[6]
          SPDYNposts.value   = LOCobj.baseObject.posts   = LOCsizeArray[5]
          SPDYNedgeoff.range.y = SPDYNlength.value/4
          if SPDYNedgeoff.value > (SPDYNlength.value/4) then SPDYNedgeoff.value = (SPDYNlength.value/4)
        )
        setAppData LOCobj 423 (LOCobj.baseObject.type as string)
        setAppData LOCobj 424 (LOCsignPath + LOCnewFile + ".ini")
        DYNFUNsignParams LOCobj
        DYNproperties.DYNFUNupdPropertiesPanel()
      )
      else
      (
        undo off
        (
          local LOCnewMatID = findItem LOCsignsArray LOCnewFile
          if LOCobj.baseObject.type != LOCnewMatID then
          (
            LOCobj.baseObject.type = LOCnewMatID + 10

            local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 4 LOCresourceKitMode
            SPDYNlength.value  = LOCobj.baseObject.width   = LOCsizeArray[3]
            SPDYNwidth.value   = LOCobj.baseObject.height  = LOCsizeArray[4]
            LOCaspectRatio     = SPDYNlength.value / SPDYNwidth.value
            if (classof LOCobj.baseObject) == VSP_Sign then
            (
              SPDYNheight.value  = LOCobj.baseObject.pheight = LOCsizeArray[4] + LOCsizeArray[6]
              SPDYNposts.value   = LOCobj.baseObject.posts   = LOCsizeArray[5]
              SPDYNedgeoff.range.y = SPDYNlength.value/4
              if SPDYNedgeoff.value > (SPDYNlength.value/4) then SPDYNedgeoff.value = (SPDYNlength.value/4)
            )
            setAppData LOCobj 423 (LOCobj.baseObject.type as string)
            setAppData LOCobj 424 (LOCsignPath + LOCnewFile + ".ini")
            DYNFUNsignParams LOCobj
            DYNproperties.DYNFUNupdPropertiesPanel()
          )
        )
      )
    )
  )

  on CBDYNlinked changed arg do
  (
    if arg == false then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNsignParams LOCobj 4 false
      select LOCobj
    )
  )

  on PKDYNlinkSign picked arg do
  (
    if arg != LOCobj then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNsignParams LOCobj 4 true
      instanceReplace LOCobj arg
      select LOCobj
    )
  )

  on PKDYNlinkSymb picked arg do
  (
    if arg != LOCobj then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNsignParams LOCobj 4 true
      instanceReplace LOCobj arg
      select LOCobj
    )
  )
)
